;----------========== Parsing (common to every scripts) ==========----------
; The script is being passed 2 parameters by mGalaxy.
; The first one contains the full path to the emulator.
; The second one contains parameters (optional) for the emulator PLUS the full path (between quotes) to the rom file.
;
; Line 13: $CmdLine is an array of size 3. $CmdLine[0] returns the total number of items in the array, $CmdLine[1] the 1st parameter, $CmdLine[2] the 2nd parameter
; Line 19: AutoIt requires that parameters sent by mGalaxy be enclosed in quotation marks.
;          As the parameters themselves contain quotation marks, these have been replaced by a distinguishing sign (%s) so as not to cause any confusion in the constitution of the command line.
;          So we now replace this distinguishing sign with quotation marks.
; Line 20: Some apps (MESS for instance, when it searchs for a system Bios) need to know the path to their 'Working Directory'. We do extract it from the emulator full path.
;
#include <MsgBoxConstants.au3>
If UBound($CmdLine) <> 3 Then
   MsgBox($MB_SYSTEMMODAL, "Script execution error", "The script was expecting to receive 2 parameters but received " & UBound($CmdLine)-1, 10)
   Exit 0
EndIf

local $app = $CmdLine[1]
local $command = StringReplace($CmdLine[2], "%s", """")
Local $workingDir = StringRegExpReplace($app, "\\[^\\]*$", "")
FileChangeDir($workingDir)
;---------------------------------------------------------------------------

;Associating name to number
$N = 0
If $command = "starglad" Then $N = 1  ;Star Gladiator (US 960627)
If $command = "sfex"     Then $N = 2  ;Street Fighter EX (US 961219)
If $command = "sfexj"    Then $N = 3  ;Street Fighter EX (JP 961130)
If $command = "sfexa"    Then $N = 4  ;Street Fighter EX (ASIA 961219)
If $command = "sfexp"    Then $N = 5  ;Street Fighter EX Plus (US 970407)
If $command = "sfexpu1"  Then $N = 6  ;Street Fighter EX Plus (US 970311)
If $command = "sfexpj"   Then $N = 7  ;Street Fighter EX Plus (JP 970311)
If $command = "sfex2"    Then $N = 8  ;Street Fighter EX 2 (US 980526)
If $command = "sfex2j"   Then $N = 9  ;Street Fighter EX 2 (JP 980312)
If $command = "sfex2p"   Then $N = 10 ;Street Fighter EX 2 PLUS (US 990611)
If $command = "sfex2pj"  Then $N = 11 ;Street Fighter EX 2 PLUS (JP 990611)
If $command = "sfex2pa"  Then $N = 12 ;Street Fighter EX 2 PLUS (ASIA 990611)
If $command = "plsmaswd" Then $N = 13 ;Plasma Sword (US 980316)
If $command = "stargld2" Then $N = 14 ;Star Gladiator 2 (JP 980316)
If $command = "rvschola" Then $N = 15 ;Rival Schools (ASIA 971117)
If $command = "jgakuen"  Then $N = 16 ;Justice Gakuen (JP 991117)
If $command = "rvschool" Then $N = 17 ;Rival Schools (US 971117)
If $command = "shiryu2"  Then $N = 18 ;Strider Hiryu 2 (JP 991213)
If $command = "strider2" Then $N = 19 ;Strider 2 (ASIA 991213)
If $command = "kikaioh"  Then $N = 20 ;Kikaioh (JP 980914)
If $command = "techromn" Then $N = 21 ;Tech Romancer (US 980914)
If $command = "ts2"      Then $N = 22 ;Battle Arena Toshinden 2 (US 951124)
If $command = "ts2j"     Then $N = 23 ;Battle Arena Toshinden 2 (JP 951124)
If $command = "tgmj"     Then $N = 24 ;Tetris The Grand Master (JP 980710)
If $command = "sncwgltd" Then $N = 25 ;Sonic Wings Limited (JP)
If $command = "beastrzb" Then $N = 26 ;Beastorizer (US) *bootleg*
If $command = "beastrzr" Then $N = 27 ;Beastorizer (US)
If $command = "bldyror2" Then $N = 28 ;Bloody Roar 2 (JP)
If $command = "brvblade" Then $N = 29 ;Brave Blade (JP)
If $command = "psyforcj" Then $N = 30 ;Psychic Force (JP 2.4J)
If $command = "psyforce" Then $N = 31 ;Psychic Force (World 2.4O)
If $command = "psyfrcex" Then $N = 32 ;Psychic Force EX (JP 2.0J)
If $command = "mgcldtex" Then $N = 33 ;Magical Date EX - sotsugyou kokuhaku daisakusen (JP 2.01J)
If $command = "raystorj" Then $N = 34 ;Raystorm (JP 2.05J)
If $command = "raystorm" Then $N = 35 ;Raystorm (US 2.06A)
If $command = "ftimpcta" Then $N = 36 ;Fighters Impact A (JP 2.00J)
If $command = "gdarius"  Then $N = 37 ;G-Darius (JP 2.01J)
If $command = "gdarius2" Then $N = 38 ;G-Darius Ver.2 (JP 2.03J)
If $command = "danceyes" Then $N = 39 ;Dancing Eyes (JP) Ver. A
If $command = "xevi3dg"  Then $N = 40 ;Xevious 3D/G (JP) Ver. A
If $command = "starswep" Then $N = 41 ;Star Sweep (JP) Ver. A
If $command = "myangel3" Then $N = 42 ;Kosodate Quiz My Angel 3 (JP) Ver. A
If $command = "tekkenb"  Then $N = 43 ;Tekken (JP) Ver. B
If $command = "tekkena"  Then $N = 44 ;Tekken (WORLD) Ver. B
If $command = "tekken"   Then $N = 45 ;Tekken (WORLD) Ver. C
If $command = "tekken2a" Then $N = 46 ;Tekken 2 (JP) Ver. B
If $command = "tekken2b" Then $N = 47 ;Tekken 2 (World) Ver. A
If $command = "tekken2"  Then $N = 48 ;Tekken 2 (World) Ver. B
If $command = "souledga" Then $N = 49 ;Soul Edge (JP) SO3 Ver. A
If $command = "souledgb" Then $N = 50 ;Soul Edge (JP) SO1 Ver. A
If $command = "souledge" Then $N = 51 ;Soul Edge Ver. II (JP) SO4 Ver. C
If $command = "dunkmnia" Then $N = 52 ;Dunk Mania (US) DM2 Ver. C
If $command = "dunkmnic" Then $N = 53 ;Dunk Mania (JP) DM1 Ver. C
If $command = "primglex" Then $N = 54 ;Prime Goal EX (JP) Ver. A
If $command = "weddingr" Then $N = 55 ;Wedding Rhapsody (JP) Ver. JAA
If $command = "hyperath" Then $N = 56 ;Hyper Athlete (JP) Ver. 1.00
If $command = "pbball96" Then $N = 57 ;Powerful Baseball 96 (JP) Ver. 1.03
If $command = "susume"   Then $N = 58 ;Susume! Taisen Puzzle-Dama (JP) Ver. 1.20
If $command = "fgtlayer" Then $N = 59 ;Fighting Layer (JP) Ver. B
If $command = "ehrgeiz"  Then $N = 60 ;Ehrgeiz (US) Ver. A
If $command = "tekken3"  Then $N = 61 ;Tekken 3 (JP) Ver. A
If $command = "mrdrillr" Then $N = 62 ;Mr Driller (JP) Ver. A
If $command = "aquarush" then $N = 63 ;Aqua Rush (JP) Ver. A
If $command = "pacapp"   Then $N = 64 ;Paca Paca Passion (JP) Ver. A
If $command = "glpracr3" Then $N = 65 ;Gallop Racer 3 (JP)
If $command = "shngmtkb" Then $N = 66 ;Shanghai Matekibuyuu (JP)
If $command = "cbaj"     Then $N = 67 ;Cool Boarders Arcade Jam (US)
If $command = "doapp"    Then $N = 68 ;Dead or Alive++
If $command = "tondemo"  Then $N = 69 ;Tondemo Crisis
If $command = "mfjump"   Then $N = 70 ;Monster Farm Jump (JP)
If $command = "hvnsgate" Then $N = 71 ;Heaven's Gate

If $N = 0 Then Exit 0
; Launching
$com = '"' & $app & '" ' & $N & " --use-config-file=zinc.cfg"
$PID = Run(@ComSpec & " /c " & $com, "", @SW_HIDE) ;

While ProcessExists ( $PID )
  Sleep(500)
WEnd

exit 0