;----------========== Parsing (common to every scripts) ==========----------
; The script is being passed 2 parameters by mGalaxy.
; The first one contains the full path to the emulator.
; The second one contains parameters (optional) for the emulator PLUS the full path (between quotes) to the rom file.
;
; Line 13: $CmdLine is an array of size 3. $CmdLine[0] returns the total number of items in the array, $CmdLine[1] the 1st parameter, $CmdLine[2] the 2nd parameter
; Line 19: AutoIt requires that parameters sent by mGalaxy be enclosed in quotation marks.
;          As the parameters themselves contain quotation marks, these have been replaced by a distinguishing sign (%s) so as not to cause any confusion in the constitution of the command line.
;          So we now replace this distinguishing sign with quotation marks.
; Line 20: Some apps (MESS for instance, when it searchs for a system Bios) need to know the path to their 'Working Directory'. We do extract it from the emulator full path.
;
#include <MsgBoxConstants.au3>
If UBound($CmdLine) <> 3 Then
   MsgBox($MB_SYSTEMMODAL, "Script execution error", "The script was expecting to receive 2 parameters but received " & UBound($CmdLine)-1, 10)
   Exit 0
EndIf

local $app = $CmdLine[1]
local $command = StringReplace($CmdLine[2], "%s", """")
Local $workingDir = StringRegExpReplace($app, "\\[^\\]*$", "")
FileChangeDir($workingDir)
;---------------------------------------------------------------------------

Local $openingCMD
Local $closingCMD

;Check path to DTLite.exe (way to detect and use DaemonTools v5)
Local $pathdaemon = RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\DTLite.exe", "")
If not $pathdaemon Then
	;Check path to DTAgent.exe (way to detect and use DaemonTools v10)
	$pathdaemon = RegRead("HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Run", "DAEMON Tools Lite Automount")
	If not $pathdaemon Then
		MsgBox(4096, "Search error", "DAEMON Tools Lite not found. Please install it!")
		exit 0
	Endif
	$pathdaemon = StringTrimRight ( $pathdaemon, 9 )
	$openingCMD = $pathdaemon & ' -mount_to M, ' & $command
	$closingCMD = $pathdaemon & ' -unmount M'
Else
	$pathdaemon = '"' & $pathdaemon & '"'
	$openingCMD = $pathdaemon & ' -mount 0,' & $command
	$closingCMD = $pathdaemon & ' -unmount 0'
Endif

RunWait($openingCMD)
RunWait('"' & $app & '"')
RunWait($closingCMD)

Exit 0