;----------========== Parsing (common to every scripts) ==========----------
; The script is being passed 2 parameters by mGalaxy.
; The first one contains the full path to the emulator.
; The second one contains parameters (optional) for the emulator PLUS the full path (between quotes) to the rom file.
;
; Line 13: $CmdLine is an array of size 3. $CmdLine[0] returns the total number of items in the array, $CmdLine[1] the 1st parameter, $CmdLine[2] the 2nd parameter
; Line 19: AutoIt requires that parameters sent by mGalaxy be enclosed in quotation marks.
;          As the parameters themselves contain quotation marks, these have been replaced by a distinguishing sign (%s) so as not to cause any confusion in the constitution of the command line.
;          So we now replace this distinguishing sign with quotation marks.
; Line 20: Some apps (MESS for instance, when it searchs for a system Bios) need to know the path to their 'Working Directory'. We do extract it from the emulator full path.
;
#include <MsgBoxConstants.au3>

If UBound($CmdLine) <> 3 Then
   MsgBox($MB_SYSTEMMODAL, "Script execution error", "The script was expecting to receive 2 parameters but received " & UBound($CmdLine)-1, 10)
   Exit 0
EndIf

local $app = $CmdLine[1]
local $command = StringReplace($CmdLine[2], "%s", """")
Local $workingDir = StringRegExpReplace($app, "\\[^\\]*$", "")
FileChangeDir($workingDir)
;---------------------------------------------------------------------------

local $keywaspressed = False
HotKeySet("{ESC}", "Terminate")

; Override the default cmd.exe parameters formating by removing the starting '"/C ' and ending '"'
$command = StringTrimLeft($command, 4 )
$command = StringTrimRight($command, 1 )

; Resolve .lnk path
Local $aDetails = FileGetShortcut($command)
If @error Then
	Exit 0
EndIf

; Define Working Directory
FileChangeDir($aDetails[1])

; List processes
Local $aProcesses1 = ProcessList()
If @error Then
	Exit 0
EndIf

; Launch app
$PID = Run ($aDetails[0])

; Wait for ESC key being pressed
While Not $keywaspressed
   sleep(500)
WEnd

; List processes again
Local $aProcesses2 = ProcessList()
If @error Then
	Exit 0
EndIf

; Get difference between 2 arrays
Local $aDifference[1]
For $i = 1 To UBound($aProcesses2) - 1
    Local $bFound = False
    For $j = 1 To UBound($aProcesses1) - 1
        If $aProcesses2[$i][1] = $aProcesses1[$j][1] Then
            $bFound = True
            ExitLoop
        EndIf
    Next
    If Not $bFound Then
        ReDim $aDifference[UBound($aDifference) + 1]
        $aDifference[UBound($aDifference) - 1] = $aProcesses2[$i][0]
    EndIf
 Next

; Get full path of process
With ObjGet("winmgmts:")
	 For $i = 0 To UBound($aDifference) - 1
		 $oProcesses = .ExecQuery("SELECT Handle, Caption, ExecutablePath FROM Win32_Process WHERE Name = '" & $aDifference[$i] & "'")
		 ; In AutoIt, when executing a WMI query using the .ExecQuery() method, if no results are found, the returned object is still a valid (empty) collection

		 For $oProcess In $oProcesses
			If StringLeft($oProcess.ExecutablePath, StringLen($aDetails[1])) == $aDetails[1] Then
			   $oProcess.Terminate()
			EndIf
		 Next
	 Next
 EndWith

; Exit script
Exit 0

; Terminate function
Func Terminate()
   $keywaspressed = True
EndFunc
